<?php
require_once 'config/config.php';
require_once 'config/database.php';

// Check if already installed
if (file_exists('installed.lock')) {
    die('System already installed. Please delete installed.lock to reinstall.');
}

// Database installation
try {
    $db = new Database();
    
    // Read and execute schema
    $schema = file_get_contents('database/schema.sql');
    $queries = explode(';', $schema);
    
    foreach ($queries as $query) {
        $query = trim($query);
        if (!empty($query)) {
            $db->query($query);
            $db->execute();
        }
    }
    
    echo "<h1>Financial Management System - Installation Complete</h1>";
    echo "<p>Database successfully installed!</p>";
    echo "<p>Default admin credentials:</p>";
    echo "<ul>";
    echo "<li>Username: admin</li>";
    echo "<li>Password: admin123</li>";
    echo "</ul>";
    echo "<p><a href='login.php'>Go to Login Page</a></p>";
    
    // Create lock file
    file_put_contents('installed.lock', 'Installation completed: ' . date('Y-m-d H:i:s'));
    
} catch (Exception $e) {
    echo "<h1>Installation Error</h1>";
    echo "<p>Error: " . $e->getMessage() . "</p>";
    echo "<p>Please check your database configuration and try again.</p>";
}
?>