<?php
define('PAGE_TITLE', 'Dashboard');
require_once 'config/config.php';
require_once 'libraries/Auth.php';

$auth = new Auth();
$auth->requireLogin();

include 'views/layouts/header.php';
?>

<div class="row">
    <div class="col-12">
        <h1 class="h3 mb-4">Dashboard</h1>
    </div>
</div>

<!-- Statistics Cards -->
<div class="row mb-4">
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="stat-card">
            <div class="d-flex align-items-center">
                <div class="stat-icon bg-primary text-white me-3">
                    <i class="fas fa-money-bill-wave"></i>
                </div>
                <div>
                    <h6 class="text-muted mb-1">Total Revenue</h6>
                    <h4 class="mb-0" id="totalRevenue">Rp 0</h4>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="stat-card">
            <div class="d-flex align-items-center">
                <div class="stat-icon bg-success text-white me-3">
                    <i class="fas fa-chart-line"></i>
                </div>
                <div>
                    <h6 class="text-muted mb-1">Net Profit</h6>
                    <h4 class="mb-0" id="netProfit">Rp 0</h4>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="stat-card">
            <div class="d-flex align-items-center">
                <div class="stat-icon bg-warning text-white me-3">
                    <i class="fas fa-boxes"></i>
                </div>
                <div>
                    <h6 class="text-muted mb-1">Total Items</h6>
                    <h4 class="mb-0" id="totalItems">0</h4>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="stat-card">
            <div class="d-flex align-items-center">
                <div class="stat-icon bg-info text-white me-3">
                    <i class="fas fa-users"></i>
                </div>
                <div>
                    <h6 class="text-muted mb-1">Total Customers</h6>
                    <h4 class="mb-0" id="totalCustomers">0</h4>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Charts Row -->
<div class="row mb-4">
    <div class="col-lg-8">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">Revenue vs Expenses</h5>
                <div class="btn-group" role="group">
                    <button type="button" class="btn btn-sm btn-outline-primary active" data-period="month">Month</button>
                    <button type="button" class="btn btn-sm btn-outline-primary" data-period="quarter">Quarter</button>
                    <button type="button" class="btn btn-sm btn-outline-primary" data-period="year">Year</button>
                </div>
            </div>
            <div class="card-body">
                <div class="chart-container">
                    <canvas id="revenueChart"></canvas>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-lg-4">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Account Balance Distribution</h5>
            </div>
            <div class="card-body">
                <div class="chart-container">
                    <canvas id="balanceChart"></canvas>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Recent Activities & Quick Actions -->
<div class="row">
    <div class="col-lg-8">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Recent Activities</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover" id="recentActivitiesTable">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Activity</th>
                                <th>User</th>
                                <th>Amount</th>
                            </tr>
                        </thead>
                        <tbody>
                            <!-- Data will be loaded via AJAX -->
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-lg-4">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Quick Actions</h5>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <button class="btn btn-primary" onclick="openModal('newInvoice')">
                        <i class="fas fa-plus me-2"></i>New Invoice
                    </button>
                    <button class="btn btn-success" onclick="openModal('newPurchase')">
                        <i class="fas fa-shopping-cart me-2"></i>New Purchase
                    </button>
                    <button class="btn btn-info" onclick="openModal('newJournal')">
                        <i class="fas fa-book me-2"></i>New Journal
                    </button>
                    <button class="btn btn-warning" onclick="openModal('newPayment')">
                        <i class="fas fa-credit-card me-2"></i>Record Payment
                    </button>
                </div>
            </div>
        </div>
        
        <div class="card mt-3">
            <div class="card-header">
                <h5 class="mb-0">Alerts</h5>
            </div>
            <div class="card-body">
                <div id="alertsContainer">
                    <!-- Alerts will be loaded via AJAX -->
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modals -->
<div class="modal fade" id="newInvoiceModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">New Sales Invoice</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form id="newInvoiceForm">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Customer</label>
                                <select class="form-select" name="customer_id" required>
                                    <option value="">Select Customer</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Invoice Date</label>
                                <input type="date" class="form-control" name="invoice_date" value="<?php echo date('Y-m-d'); ?>" required>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="table-responsive">
                                <table class="table table-sm" id="invoiceItems">
                                    <thead>
                                        <tr>
                                            <th>Item</th>
                                            <th>Qty</th>
                                            <th>Price</th>
                                            <th>Total</th>
                                            <th></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>
                                                <select class="form-select" name="items[0][item_id]" required>
                                                    <option value="">Select Item</option>
                                                </select>
                                            </td>
                                            <td>
                                                <input type="number" class="form-control" name="items[0][quantity]" min="1" value="1" required>
                                            </td>
                                            <td>
                                                <input type="number" class="form-control" name="items[0][unit_price]" min="0" step="0.01" required>
                                            </td>
                                            <td>
                                                <input type="number" class="form-control" name="items[0][total_price]" readonly>
                                            </td>
                                            <td>
                                                <button type="button" class="btn btn-sm btn-danger" onclick="removeItem(this)">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <button type="button" class="btn btn-sm btn-secondary" onclick="addItem()">
                                    <i class="fas fa-plus"></i> Add Item
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" onclick="saveInvoice()">Save Invoice</button>
            </div>
        </div>
    </div>
</div>

<script>
// Dashboard functionality
document.addEventListener('DOMContentLoaded', function() {
    loadDashboardData();
    loadCharts();
});

function loadDashboardData() {
    fetch(BASE_URL + 'api/dashboard/summary.php')
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                document.getElementById('totalRevenue').textContent = formatCurrency(data.summary.total_revenue);
                document.getElementById('netProfit').textContent = formatCurrency(data.summary.net_profit);
                document.getElementById('totalItems').textContent = data.summary.total_items;
                document.getElementById('totalCustomers').textContent = data.summary.total_customers;
            }
        });
}

function loadCharts() {
    // Revenue Chart
    const revenueCtx = document.getElementById('revenueChart').getContext('2d');
    new Chart(revenueCtx, {
        type: 'line',
        data: {
            labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun'],
            datasets: [{
                label: 'Revenue',
                data: [12000000, 19000000, 15000000, 25000000, 22000000, 30000000],
                borderColor: 'rgb(75, 192, 192)',
                backgroundColor: 'rgba(75, 192, 192, 0.2)',
                tension: 0.1
            }, {
                label: 'Expenses',
                data: [8000000, 12000000, 9000000, 15000000, 14000000, 18000000],
                borderColor: 'rgb(255, 99, 132)',
                backgroundColor: 'rgba(255, 99, 132, 0.2)',
                tension: 0.1
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'top',
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) {
                            return 'Rp ' + value.toLocaleString('id-ID');
                        }
                    }
                }
            }
        }
    });

    // Balance Chart
    const balanceCtx = document.getElementById('balanceChart').getContext('2d');
    new Chart(balanceCtx, {
        type: 'doughnut',
        data: {
            labels: ['Cash', 'Bank', 'Receivables', 'Payables'],
            datasets: [{
                data: [50000000, 150000000, 75000000, 45000000],
                backgroundColor: [
                    'rgba(255, 99, 132, 0.8)',
                    'rgba(54, 162, 235, 0.8)',
                    'rgba(255, 205, 86, 0.8)',
                    'rgba(75, 192, 192, 0.8)'
                ]
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'bottom'
                }
            }
        }
    });
}

function openModal(type) {
    switch(type) {
        case 'newInvoice':
            $('#newInvoiceModal').modal('show');
            break;
        // Add other cases
    }
}

function addItem() {
    const tbody = document.querySelector('#invoiceItems tbody');
    const rowCount = tbody.rows.length;
    
    const newRow = tbody.insertRow();
    newRow.innerHTML = `
        <td>
            <select class="form-select" name="items[${rowCount}][item_id]" required>
                <option value="">Select Item</option>
            </select>
        </td>
        <td>
            <input type="number" class="form-control" name="items[${rowCount}][quantity]" min="1" value="1" required>
        </td>
        <td>
            <input type="number" class="form-control" name="items[${rowCount}][unit_price]" min="0" step="0.01" required>
        </td>
        <td>
            <input type="number" class="form-control" name="items[${rowCount}][total_price]" readonly>
        </td>
        <td>
            <button type="button" class="btn btn-sm btn-danger" onclick="removeItem(this)">
                <i class="fas fa-trash"></i>
            </button>
        </td>
    `;
}

function removeItem(button) {
    const row = button.closest('tr');
    if (document.querySelectorAll('#invoiceItems tbody tr').length > 1) {
        row.remove();
    }
}

function saveInvoice() {
    // Implementation for saving invoice
    showSuccess('Invoice saved successfully!');
    $('#newInvoiceModal').modal('hide');
}

// Initialize DataTables
initDataTable('recentActivitiesTable', {
    ajax: BASE_URL + 'api/dashboard/recent-activities.php',
    columns: [
        { data: 'date' },
        { data: 'activity' },
        { data: 'user' },
        { data: 'amount', render: function(data) { return formatCurrency(data); } }
    ],
    order: [[0, 'desc']]
});
</script>

<?php include 'views/layouts/footer.php'; ?>