<?php
require_once '../../config/config.php';
require_once '../../config/database.php';
require_once '../../libraries/Auth.php';

header('Content-Type: application/json');

$auth = new Auth();
if (!$auth->isLoggedIn()) {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized']);
    exit();
}

$db = new Database();
$companyId = $_SESSION['company_id'] ?? 1;

try {
    $category = $_GET['category'] ?? '';
    $status = $_GET['status'] ?? '';
    $search = $_GET['search'] ?? '';
    
    $query = "
        SELECT 
            i.*,
            ic.name as category_name,
            COALESCE(SUM(il.quantity_on_hand), 0) as total_stock,
            COALESCE(AVG(il.average_cost), 0) as average_cost,
            COALESCE(SUM(il.total_value), 0) as total_value
        FROM items i
        LEFT JOIN item_categories ic ON i.category_id = ic.id
        LEFT JOIN inventory_locations il ON i.id = il.item_id
        WHERE i.company_id = :company_id
    ";
    
    $params = [':company_id' => $companyId];
    
    if ($category !== '') {
        $query .= " AND i.category_id = :category";
        $params[':category'] = $category;
    }
    
    if ($status !== '') {
        $query .= " AND i.is_active = :status";
        $params[':status'] = $status;
    }
    
    if ($search !== '') {
        $query .= " AND (i.code LIKE :search OR i.name LIKE :search OR ic.name LIKE :search)";
        $params[':search'] = "%$search%";
    }
    
    $query .= " GROUP BY i.id ORDER BY i.code ASC";
    
    $db->query($query);
    
    foreach ($params as $key => $value) {
        $db->bind($key, $value);
    }
    
    $items = $db->resultSet();
    
    echo json_encode([
        'success' => true,
        'items' => $items
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Database error: ' . $e->getMessage()
    ]);
}
?>